-- This script creates an empty physical material and adds it to the Slate Editor
-- the map type is also changed, although its only done as an example as no maps are created.

-- To find out which parameters you can you for 'mtl_api.set_preset', 'mtl_api.set_mapType' and 'mtl_api.set_materialType'
-- you can use the functions 'mtl_api.available_presets()'mtl_api.available_mapTypes()' and 'mtl_api.available_MaterialTypes()'
-- or get a full overview with 'mtl_api.show()'.

-- "Default" preset sets the mapType and materialType to "Render"
-- set_mapType and set_materialType will overwrite the preset values.

(
	mtl_api.open() 						-- opens the MTL rollout menu
										-- you can also run this script with 'mtl_api.close()'
	--
	mtl_api.clear() 					-- clears textures, channels and material
	--
	mtl_api.set_preset "Default" 		-- loads the default MTL settings
	mtl_api.set_mapType "Standard" 		-- sets map type to Standard maps
	mtl_api.set_materialType "Physical" -- sets material type to Physical maps
	--
	mtl_api.create_material() 			-- creates a new material
	mtl_api.addToSlate() 				-- add created material to view 1 of the Slate Material Editor
)